# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.

from . import stylesheet

BASE_COLOR_BLOCKS = [
    '.acronisBranding',
    '.acronisBrandingColor',
    '.acronisBrandingAccent',
    '.acronisBrandingAccentColor',
    '.acronisBrandingHover',
    '.acronisBrandingHoverColor'
]

SPECIAL_RULES = {
    # grid borders
    '.x-grid .x-grid-row-selected .x-grid-cell': ['border-color', 'acronisGridBorder'],
    '.x-grid .x-grid-row-selected.x-grid-row-over .x-grid-cell': ['border-color', 'acronisGridBorder'],
    '.x-grid .x-grid-row-selected.x-grid-row-over.x-grid-row-focused .x-grid-cell': ['border-color', 'acronisGridBorder'],
    '.x-grid .x-grid-row-over .x-grid-cell,.x-grid .x-grid-row-focused .x-grid-cell': ['border-color', 'acronisGridBorder'],
    # nav tree
    '.nav-tree-panel .x-panel-header-default': ['background-color', 'navTreeBg'],
    '.nav-tree-panel .x-panel-header-default .x-panel-header-text-container-default': ['color', 'navTreeFg'],
    '.x-tree-panel.x-panel-nav-tree': ['background-color', 'navTreeBg'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-cell .x-tree-node-text': ['color', 'navTreeFg'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-cell.inactive .x-tree-node-text': ['color', 'navTreeFgDisabled'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-row-selected.x-grid-row-over .x-grid-cell,.x-tree-panel.x-panel-nav-tree .x-grid-row-focused.x-grid-row-over .x-grid-cell,.x-tree-panel.x-panel-nav-tree .x-grid-row-selected .x-grid-cell': ['background-color', 'navTreeActiveBg'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-row-selected.x-grid-row-over .x-tree-node-text,.x-tree-panel.x-panel-nav-tree .x-grid-row-focused.x-grid-row-over .x-tree-node-text,.x-tree-panel.x-panel-nav-tree .x-grid-row-selected .x-tree-node-text': ['color', 'navTreeActiveFg'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-row-selected.x-grid-row-over .x-grid-cell.inactive .x-tree-node-text,.x-tree-panel.x-panel-nav-tree .x-grid-row-focused.x-grid-row-over .x-grid-cell.inactive .x-tree-node-text,.x-tree-panel.x-panel-nav-tree .x-grid-row-selected .x-grid-cell.inactive .x-tree-node-text': ['color', 'navTreeActiveFgDisabled'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-row-over': ['background-color', 'navTreeOverBg'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-row-over .x-tree-node-text': ['color', 'navTreeOverFg'],
    '.x-tree-panel.x-panel-nav-tree .x-grid-row-over .x-grid-cell.inactive .x-tree-node-text': ['color', 'navTreeOverFgDisabled']
}

COLOR_DARK_FG = '#ffffff'
COLOR_LIGHT_FG = '#000000'
COLOR_BORDER = '#dbdbdb'


def generate_accent_color(color, dark):
    h, l, s = stylesheet.rgb_to_hls(color)
    if dark:
        return stylesheet.hls_to_rgb(h, l * 0.86 if s < 0.99 else min(1, l * 1.2), s)
    else:
        return stylesheet.hls_to_rgb(h, l, s * 0.6)
        

def generate_hover_color(color, dark):
    h, l, s = stylesheet.rgb_to_hls(color)
    if dark:
        return stylesheet.hls_to_rgb(h, l * 0.92 if s < 0.99 else min(1, l * 1.4), s)
    else:
        return stylesheet.hls_to_rgb(h, l, s * 0.8)


def generate_palette(color):
    """
    Generate colors palette to apply to CSS template
    
    'acronisBranding' main branding color
    'acronisBrandingColor'  font color for branding
    'acronisBrandingAccent'
    'acronisBrandingAccentColor'
    'acronisBrandingHover'
    'acronisBrandingHoverColor'
    'acronisBorder'
    'acronisGridBorder' [$acronisBorder, $acronisBranding]
    'acronisIconScheme' ['light', 'dark']
    """

    color = stylesheet.color2rgb(color)

    dark = stylesheet.is_dark(color)
    acronis_branding = stylesheet.rgb2css(color)
    acronis_branding_accent = generate_accent_color(color, dark)
    acronis_branding_hover = generate_hover_color(color, dark)

    return {
        'acronisBranding': acronis_branding,
        'acronisBrandingColor': COLOR_DARK_FG if dark else COLOR_LIGHT_FG,
        'acronisBrandingAccent': stylesheet.rgb2css(acronis_branding_accent),
        'acronisBrandingAccentColor': COLOR_DARK_FG if stylesheet.is_dark(acronis_branding_accent) else COLOR_LIGHT_FG,
        'acronisBrandingHover': stylesheet.rgb2css(acronis_branding_hover),
        'acronisBrandingHoverColor': COLOR_DARK_FG if stylesheet.is_dark(acronis_branding_hover) else COLOR_LIGHT_FG,
        'acronisBorder': COLOR_BORDER,
        'acronisGridBorder': acronis_branding if dark else COLOR_BORDER,
        'acronisIconScheme': 'light' if dark else 'dark',
        # nav tree
        'navTreeBg': '#d8d8d8' if dark else '#808080',
        'navTreeFg': '#333333' if dark else '#ffffff',
        'navTreeFgDisabled': '#979797' if dark else '#cccccc',
        'navTreeOverBg': '#b8b8b8' if dark else '#6d6d6d',
        'navTreeOverFg': '#2d3138' if dark else '#ffffff',
        'navTreeOverFgDisabled': '#666666' if dark else '#cccccc',
        'navTreeActiveBg': '#979797' if dark else '#595959',
        'navTreeActiveFg': '#eeeeee' if dark else '#ffffff',
        'navTreeActiveFgDisabled': '#666666' if dark else '#cccccc',
    }
