import acrort
from . constants import *
from urllib.parse import parse_qs, unquote, urlparse


def resolve_local_asz_uri(conn):
    tree = conn.gtob.open_global_tree()
    vaults_root_key = acrort.gtob.ItemKey('PersonalVaults', 'dms:personal_vaults')
    vaults_root = tree.resolve_item(key=vaults_root_key)
    vaults = tree.select_children(key=vaults_root.key)
    for vault in vaults:
        attributes = vault.attributes
        if attributes is None:
            continue
        storage_uri = attributes.get_branch('.Settings.StorageUri', None)
        if storage_uri is None:
            continue
        if storage_uri.ref == TAG_URI_ASZ:
            return attributes.LocationUri.ref
    return None

# GetStorageApi from enterprise/backup/online/online_uri/impl/online_uri.cpp
def get_uri_storage_api(location_uri):
    parsed_url = urlparse(location_uri)

    if parsed_url.scheme != 'avfs' or parsed_url.path.strip("/") != 'online':
        return STORAGE_API_NONE

    params = parse_qs(unquote(parsed_url.query))

    provider = params.get('provider')
    if provider == ['MicrosoftAzure']:
        return STORAGE_API_MICROSOFT_AZURE
    if provider == ['Google']:
        return STORAGE_API_GOOGLE
    if provider == ['AmazonS3']:
        return STORAGE_API_AMAZON_S3
    if provider == ['S3Compatible']:
        return STORAGE_API_S3_COMPATIBLE
    if provider == ['Acronis']:
        return STORAGE_API_ASTOR

    return STORAGE_API_NONE

def is_ostor_uri(location_uri):
    return get_uri_storage_api(location_uri) in [STORAGE_API_MICROSOFT_AZURE, STORAGE_API_GOOGLE, STORAGE_API_AMAZON_S3, STORAGE_API_S3_COMPATIBLE]

def is_cloud_uri(location_uri):
    return get_uri_storage_api(location_uri) in [STORAGE_API_ASTOR]
