import acrort
from . request_tokens import *
from . constants import *


class BackupKind:
    def __init__(self):
        self.type = BACKUP_TYPE_FULL
        self.data_type = BACKUP_DATA_TYPE_BINARY

    def to_unit(self):
        return acrort.plain.Unit({ARG_TYPE: self.type,
                                  ARG_DATA_TYPE: self.data_type})


class BackupNowScheme:
    def __init__(self):
        self.kind = BackupKind()

    def to_unit(self):
        scheme = {ARG_TYPE: BACKUP_SCHEME_NOW,
                  ARG_PARAMETERS: {ARG_KIND: self.kind}}
        return acrort.plain.Unit(scheme)


class RunOnceScheme:
    def __init__(self):
        self.kind = BackupKind()
        self.backup_time = None

    def to_unit(self):
        scheme = {ARG_TYPE: BACKUP_SCHEME_ONCE,
                  ARG_PARAMETERS: {ARG_KIND: self.kind}}
        if self.backup_time:
            run_at = {ARG_DATE_PART: {ARG_YEAR: self.backup_time.year,
                                      ARG_MONTH: self.backup_time.month,
                                      ARG_DAY: self.backup_time.day},
                      ARG_TIME_PART: {ARG_HOUR: self.backup_time.hour,
                                      ARG_MINUTE: self.backup_time.minute,
                                      ARG_SECOND: self.backup_time.second}}
            scheme[ARG_PARAMETERS][ARG_BACKUP_TIME] = run_at
        return acrort.plain.Unit(scheme)


class DailyCalendar:
    def __init__(self, day_interval):
        self._day_interval = day_interval

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: DAILY_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_DAY_INTERVAL: self._day_interval}}}
        return acrort.plain.Unit(alarm)


class WeeklyCalendar:
    def __init__(self, week_interval):
        self._week_interval = week_interval

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: WEEKLY_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_WEEK_INTERVAL: self._week_interval}}}
        return acrort.plain.Unit(alarm)


class MonthlyDateCalendar:
    def __init__(self, days, months):
        self._days = days
        self._months = months

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: MONTHLY_DATE_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_DAYS: self._days, ARG_MONTHS: self._months}}}
        return acrort.plain.Unit(alarm)


class MonthlyDayOfWeekCalendar:
    def __init__(self, days, weeks):
        self._days = days
        self._weeks = weeks

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: MONTHLY_DAY_OF_WEEK_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_DAYS: self._days, ARG_WEEKS: self._weeks}}}
        return acrort.plain.Unit(alarm)


class MonthlyPeriodicDatePeriodicCalendar:
    def __init__(self, days, months):
        self._days = days
        self._months = months

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: MONTHLY_PERIODIC_DATE_PERIODIC_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_DAYS: self._days, ARG_MONTHS: self._months}}}
        return acrort.plain.Unit(alarm)


class MonthlyPeriodicDateMaskCalendar:
    def __init__(self, days, months):
        self._days = days
        self._months = months

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: MONTHLY_PERIODIC_DATE_MASK_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_DAYS: self._days, ARG_MONTHS: self._months}}}
        return acrort.plain.Unit(alarm)


class MonthlyPeriodicDayOfWeekCalendar:
    def __init__(self, days, months, weeks):
        self._days = days
        self._months = months
        self._weeks = weeks

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: MONTHLY_PERIODIC_DAY_OF_WEEK_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_DAYS: self._days, ARG_MONTHS: self._months, ARG_WEEKS: self._weeks}}}
        return acrort.plain.Unit(alarm)


class MonthlyMaskDatePeriodicCalendar:
    def __init__(self, days, months):
        self._days = days
        self._months = months

    def to_unit(self):
        alarm = {ARG_CALENDAR: {
            ARG_POLY_TYPE: MONTHLY_MASK_DATE_PERIODIC_CALENDAR_CLASS_ID,
            ARG_IMPL: {ARG_DAYS: self._days, ARG_MONTHS: self._months}}}
        return acrort.plain.Unit(alarm)


class Alarm:
    def __init__(self):
        self.once_a_day_flag = False


class TimeDistrbutionParameters:
    def __init__(self):
        self.enabled = False
        self.interval = 0
        self.distribution_method = 0

    def to_unit(self):
        return acrort.plain.Unit({
            ARG_ENABLED: self.enabled,
            ARG_INTERVAL: self.interval,
            ARG_METHOD: self.distribution_method})


def date_unit(date=None):
    if date:
        return acrort.plain.Unit({ARG_YEAR: date.year, ARG_MONTH: date.month, ARG_DAY: date.day})
    return acrort.plain.Unit({ARG_YEAR: 0, ARG_MONTH: 0, ARG_DAY: 0})


def time_unit(time=None):
    if time:
        return acrort.plain.Unit({ARG_HOUR: time.hour, ARG_MINUTE: time.minute, ARG_SECOND: time.second})
    return acrort.plain.Unit({ARG_HOUR: 0, ARG_MINUTE: 0, ARG_SECOND: 0})


class RepeatDuringDay:
    def __init__(self):
        self.time_iterval = 0
        self.end_time = None

    def to_unit(self):
        return acrort.plain.Unit({ARG_TIME_INTERVAL: self.time_iterval, ARG_END_TIME: time_unit(self.end_time)})


class TimeAlarm(Alarm):
    def __init__(self, calendar):
        super(TimeAlarm, self).__init__()
        self._calendar = calendar
        self.machine_wake = False
        self.run_later = True
        self.utc_based_settings = False
        self.begin_date = None
        self.end_date = None
        self.start_time = None
        self.repeat_at_day = RepeatDuringDay()
        self.start_time_delay = 0
        self.skip_occurrences = 0
        self.distribution = TimeDistrbutionParameters()

    def to_unit(self):
        alarm = {ARG_ALARM: {
            ARG_ONCE_A_DAY: self.once_a_day_flag,
            ARG_POLY_TYPE: TIME_ALARM_CLASS_ID,
            ARG_IMPL: {
                ARG_CALENDAR: self._calendar,
                ARG_MACHINE_WAKE: self.machine_wake,
                ARG_RUN_LATER: self.run_later,
                ARG_UTC_BASED_SETTINGS: self.utc_based_settings,
                ARG_BEGIN_DATE: date_unit(self.begin_date),
                ARG_END_DATE: date_unit(self.end_date),
                ARG_START_TIME: time_unit(self.start_time),
                ARG_REPEAT_AT_DAY: self.repeat_at_day,
                ARG_START_TIME_DELAY: self.start_time_delay,
                ARG_SKIP_OCCURRENCES: self.skip_occurrences,
                ARG_DISTRIBUTION: self.distribution}}}
        return acrort.plain.Unit(alarm)


class LogonAlarm(Alarm):
    def __init__(self, sid, session_type):
        super(LogonAlarm, self).__init__()
        self._sid = sid
        self._session_type = session_type

    def to_unit(self):
        alarm = {ARG_ALARM: {
            ARG_ONCE_A_DAY: self.once_a_day_flag,
            ARG_POLY_TYPE: LOGON_ALARM_CLASS_ID,
            ARG_IMPL: {ARG_SID: self._sid, ARG_SESSION_TYPE: self._session_type}}}
        return acrort.plain.Unit(alarm)


class LogoffAlarm(Alarm):
    def __init__(self, sid, session_type):
        super(LogoffAlarm, self).__init__()
        self._sid = sid
        self._session_type = session_type

    def to_unit(self):
        alarm = {ARG_ALARM: {
            ARG_ONCE_A_DAY: self.once_a_day_flag,
            ARG_POLY_TYPE: LOGOFF_ALARM_CLASS_ID,
            ARG_IMPL: {ARG_SID: self._sid, ARG_SESSION_TYPE: self._session_type}}}
        return acrort.plain.Unit(alarm)


class StartupAlarm(Alarm):
    def __init__(self):
        super(StartupAlarm, self).__init__()

    def to_unit(self):
        alarm = {ARG_ALARM: {
            ARG_ONCE_A_DAY: self.once_a_day_flag,
            ARG_POLY_TYPE: STARTUP_ALARM_CLASS_ID}}
        return acrort.plain.Unit(alarm)


class ShutdownAlarm(Alarm):
    def __init__(self):
        super(ShutdownAlarm, self).__init__()

    def to_unit(self):
        alarm = {ARG_ALARM: {
            ARG_ONCE_A_DAY: self.once_a_day_flag,
            ARG_POLY_TYPE: SHUTDOWN_ALARM_CLASS_ID}}
        return acrort.plain.Unit(alarm)


class PoweroffAlarm(Alarm):
    def __init__(self):
        super(PoweroffAlarm, self).__init__()

    def to_unit(self):
        alarm = {ARG_ALARM: {
            ARG_ONCE_A_DAY: self.once_a_day_flag,
            ARG_POLY_TYPE: POWEROFF_ALARM_CLASS_ID}}
        return acrort.plain.Unit(alarm)


class RebootAlarm(Alarm):
    def __init__(self):
        super(RebootAlarm, self).__init__()

    def to_unit(self):
        alarm = {ARG_ALARM: {
            ARG_ONCE_A_DAY: self.once_a_day_flag,
            ARG_POLY_TYPE: REBOOT_ALARM_CLASS_ID}}
        return acrort.plain.Unit(alarm)


class Schedule:
    def __init__(self, alarms):
        self._alarms = alarms
        self.conditions = []
        self.max_delay_period = INFINITE_PERIOD
        self.wait_action_type = ACTION_TYPE_RUN
        self.retry_period = 0
        self.max_retries = 0
        self.unique = False
        self.prevent_from_sleeping = True

    def to_unit(self):
        return acrort.plain.Unit({
            ARG_ALARMS: self._alarms,
            ARG_CONDITIONS: self.conditions,
            ARG_MAX_DELAY_PERIOD: self.max_delay_period,
            ARG_WAIT_ACTION_TYPE: self.wait_action_type,
            ARG_RETRY_PERIOD: self.retry_period,
            ARG_MAX_RETRY: self.max_retries,
            ARG_UNIQUE: self.unique,
            ARG_PREVENT_FROM_SLEEPING: self.prevent_from_sleeping})


class BackupScheduleItem:
    def __init__(self, schedule):
        self.kind = BackupKind()
        self._schedule = schedule

    def to_unit(self):
        return acrort.plain.Unit({ARG_KIND: self.kind, ARG_SCHEDULE: self._schedule})


class SimpleScheme:
    def __init__(self, backup_schedule):
        self._backup_schedule = backup_schedule

    def to_unit(self):
        scheme = {
            ARG_TYPE: BACKUP_SCHEME_SIMPLE,
            ARG_PARAMETERS: {ARG_BACKUP_SCHEDULE: self._backup_schedule}}
        return acrort.plain.Unit(scheme)


class CustomScheme:
    def __init__(self, items):
        self._items = items

    def to_unit(self):
        scheme = {
            ARG_TYPE: BACKUP_SCHEME_CUSTOM,
            ARG_PARAMETERS: {ARG_ITEMS: self._items}}
        return acrort.plain.Unit(scheme)
