import multiprocessing
import threading
import acrort
import sys


def interruptable_workflow(logic, completion, result, errors):
    try:
        ret = logic()
        if ret is not None:
            result.append(ret)
    except Exception:
        errors.append(acrort.common.get_current_exception_as_error())
    completion.release()


def interruptable_execute(logic):
    completion = multiprocessing.Semaphore(0)
    result = []
    errors = []
    thread = threading.Thread(target=interruptable_workflow, args=(logic, completion, result, errors))
    thread.start()
    try:
        completion.acquire()
    except KeyboardInterrupt:
        acrort.common.translate_interrupt()
    thread.join()
    if errors:
        errors[0].throw()
    if result:
        return result[0]


def safe_execute(logic):
    try:
        ret = logic()
        if ret is not None:
            return ret
        if acrort.common.interrupt_sentinel:
            return acrort.common.INTERRUPT_AWARE_RETURN_CODE
        return 0
    except (KeyboardInterrupt, Exception):
        error = acrort.common.get_current_exception_as_error()
        sys.stderr.writelines([str(error), '\n'])
        sys.stderr.flush()
        return error.to_exit_code()


def interruptable_safe_execute(logic):
    routine = lambda: interruptable_execute(logic)
    return safe_execute(routine)
