# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.

import uuid
import hashlib


def sha256_encrypt(password, salt=None, md5_hashed=False):
    """
        @parameters:
            password - password to encrypt,
            salt - slat, if None will be generated
            md5_hashed - flag
        @return: password, salt
    """
    if salt is None:
        salt = uuid.uuid4().hex
    if not md5_hashed:
        md5 = hashlib.md5()
        md5.update(password.encode('utf-8'))
        password = md5.hexdigest()
    password = password.lower()

    passwd_hash = hashlib.sha256()
    passwd_hash.update((password + salt).encode('utf-8'))
    return passwd_hash.hexdigest(), salt
