import acrort
import os.path
import inspect
import io


def dir_here(path=None):
    caller_fname = inspect.stack()[1][1]
    dname = os.path.abspath(os.path.dirname(caller_fname))
    if path is None:
        return dname
    if not os.path.isabs(path):
        path = os.path.join(dname, path)
    path = os.path.normpath(path)
    return path


def load_binary_data(filepath):
    with io.FileIO(filepath) as file:
        return file.readall()


def save_binary_data(filepath, blob):
    with open(filepath, 'wb') as file:
        return file.write(blob)


def load_text(filename):
    with io.open(filename, mode='rt', encoding='utf8') as file:
        return file.read()


def save_text(filename, text):
    with io.open(filename, mode='wt', encoding='utf8') as file:
        file.write(text)


def load_py_object(filename):
    with io.open(filename, mode='rt', encoding='utf8') as file:
        source = file.read()
    ast = compile(source, filename, 'eval')
    return eval(ast, {"__builtins__": None}, {})


def save_py_object(filename, object):
    with io.open(filename, mode='wt', encoding='utf8') as file:
        file.writelines([str(object), '\n'])


class FileLock:
    def __init__(self, path, *, exclusive=False, mode=None):
        self._path = path
        self._exclusive = exclusive
        self._mode = mode
        self._impl = None

    def __enter__(self):
        if self._exclusive:
            self._impl = acrort.fs.FileWriteLock(self._path, mode=self._mode)
        else:
            self._impl = acrort.fs.FileReadLock(self._path, mode=self._mode)
        return self

    def __exit__(self, type, value, traceback):
        self._impl.close()
