# @copyright (c) 2002-2015 Acronis International GmbH. All rights reserved.
# since    $Id$

__author__ = "Bulat Gaifullin (bulat.gaifullin@acronis.com)"


import hmac
import base64


def make_signature(key, msg):
    """
    Sign the message
    :param key:  the key to sign
    :param msg:  the message
    :return: the base64 encoded signature
    """
    if isinstance(msg, str):
        msg = msg.encode('utf8')

    if isinstance(key, str):
        key = key.encode("utf8")

    return base64.urlsafe_b64encode(hmac.new(key, msg, 'sha1').digest()).decode('ascii')


def check(key, msg, signature):
    """
    :param key: the key to sign
    :param msg: the message
    :param signature: the signature of message
    :return: True if signature valid, otherwise False
    """
    if isinstance(signature, str):
        try:
            signature = signature.encode('ascii')
        except ValueError:
            return False

    if isinstance(key, str):
        key = key.encode("utf8")

    return hmac.compare_digest(signature, make_signature(key, msg).encode('ascii'))
