from cryptography.fernet import Fernet, InvalidToken
from base64 import urlsafe_b64encode
from hashlib import sha256
import time
import struct


class FernetHelper:

    TTL_STRUCT = "Q"
    TTL_SIZE = struct.calcsize(TTL_STRUCT)
    DAY = 86400

    def __init__(self, key):
        if isinstance(key, str):
            key = bytes(key, 'utf-8')

        self.cipher = Fernet(urlsafe_b64encode(sha256(key).digest()))

    def encrypt(self, data, ttl=DAY):
        if isinstance(data, str):
            data = bytes(data, 'utf8')

        return self.cipher.encrypt(struct.pack(self.TTL_STRUCT, int(time.time()) + int(ttl)) + data)

    def decrypt(self, data):
        if isinstance(data, str):
            data = bytes(data, 'utf8')

        payload = self.cipher.decrypt(data)

        (ttl, ), data = struct.unpack(self.TTL_STRUCT, payload[:self.TTL_SIZE]), payload[self.TTL_SIZE:]

        if time.time() > ttl:
            raise InvalidToken('Token expired')

        return data
