# @copyright (c) 2002-2014 Acronis International GmbH. All rights reserved.


def split_path_by_delimiter(path, delimiter):
    head, _, tail = path.partition(delimiter)
    return head, tail


class ObjectTree:
    __slots__ = ['_attributes', '_path_splitter', '_key_type']

    def __init__(self, path_splitter=lambda path: split_path_by_delimiter(path, '.'), key_type=str):
        super().__setattr__('_attributes', {})
        super().__setattr__('_path_splitter', path_splitter)
        super().__setattr__('_key_type', key_type)

    def __setattr__(self, path, value):
        head, tail = (self._key_type(x) for x in self._path_splitter(path))
        if tail:
            setattr(self._attributes.setdefault(head, type(self)()), tail, value)
        else:
            self._attributes[head] = value

    def __getattr__(self, item):
        try:
            return self._attributes[self._key_type(item)]
        except KeyError:
            raise AttributeError(item) from None

    def __delattr__(self, item):
        try:
            del self._attributes[self._key_type(item)]
        except KeyError:
            raise AttributeError(item) from None
