import acrort


def unit2py(unit):
    if unit.is_data():
        if (unit.type == acrort.plain.GUID) or (unit.type == acrort.plain.ERROR):
            return str(unit.ref)
        elif unit.type == acrort.plain.BLOB:
            return unit.ref.to_base64()
        return unit.ref

    if unit.is_composite():
        return {key: unit2py(value) for key, value in unit}

    if unit.is_array():
        return [unit2py(value) for idx, value in unit]
