import acrort
import sys
import io
import re

from . cmdline_parser import ArgumentsProcessor, ArgumentsHelp, ArgumentParser


TAG_LOG_FILE = 'output.logfile'
TAG_LOG_NEW = 'output.lognew'


class Output:
    def __init__(self, config=None, end=None):
        self._primary_file = sys.stdout
        self._end = end
        self._log_file = None
        if config is not None:
            logfile = config.get(TAG_LOG_FILE)
            if logfile is not None:
                log_new = config.get(TAG_LOG_NEW, False)
                if log_new:
                    log = io.open(logfile, mode='wt', encoding='utf8')
                    log.close()
                self._log_file = io.open(logfile, mode='at', encoding='utf8')

    def write(self, *objects, echo=True, end=None):
        if (self._log_file is None) and (self._primary_file is None):
            return
        lines = [str(value) for value in objects]
        if end is None:
            end = self._end
        if end is not None:
            lines.append(end)
        if echo and (self._primary_file is not None):
            for line in lines:
                written = False
                try:
                    self._primary_file.writelines([line])
                    written = True
                except UnicodeError as error:
                    pass
                if not written:
                    safe_converted_line = line.encode('ascii', 'backslashreplace').decode('utf-8')
                    self._primary_file.writelines([safe_converted_line])
            self._primary_file.flush()
        if self._log_file is not None:
            self._log_file.writelines(lines)
            self._log_file.flush()


class NullOutput:
    def __init__(self):
        pass

    def write(self, *objects, echo=True, end=None):
        pass


class OutputArgumentsProcessor(ArgumentsProcessor):
    def create_arguments_parser(self):
        parser = ArgumentParser(add_help=False)
        parser.add_argument('--log-file', metavar='FILENAME')
        parser.add_argument('--log-new', action='store_true')
        return parser

    def process_arguments(self, config, args):
        config[TAG_LOG_FILE] = args.log_file
        config[TAG_LOG_NEW] = args.log_new
