# Run as 'python.exe -m acrobind.staging.test_retention_by_count' from enterprise/pybind folder

import acrobind.staging.retention as retention
from acrobind.staging import *

import datetime
import unittest

# Ordering of generated slices is from older to newer
class TestRetentions(unittest.TestCase):

    def test_single_slice_cant_be_retained_for_zero_limit(self):
        limit = 0
        slices = [{'id': 1110, 'size': 1000, 'kind': SLICE_KIND_FULL}]
        abandoned_slices = retention.calculate_slices_abandoned_by_slice_count(slices, limit)
        print('abandoned slices: ', abandoned_slices)
        self.assertTrue(len(abandoned_slices) == 0)


    def test_single_slice_cant_be_retained_above_limit(self):
        limit = 5
        slices = [{'id': 1110, 'size': 1000, 'kind': SLICE_KIND_FULL}]
        slices += [{'id': i, 'size': i*100, 'kind': SLICE_KIND_INCREMENTAL} for i in range(1, limit)]
        abandoned_slices = retention.calculate_slices_abandoned_by_slice_count(slices, limit)
        #print('abandoned slices: ', abandoned_slices)
        self.assertTrue(len(abandoned_slices) == 0)


    def test_last_slice_should_left_after_limit(self):
        limit = 1
        slices = [{'id': 1111, 'size': 1000, 'kind': SLICE_KIND_FULL}]
        slices += [{'id': i, 'size': i*100, 'kind': SLICE_KIND_INCREMENTAL} for i in range(1, 10)]
        slice_id_should_left = 1112
        slices += [{'id': slice_id_should_left, 'size': 1000, 'kind': SLICE_KIND_INCREMENTAL}]
        abandoned_slices = retention.calculate_slices_abandoned_by_slice_count(slices, limit)
        #print('abandoned slices: ', abandoned_slices)
        for slice in abandoned_slices:
            self.assertTrue(slice['id'] != slice_id_should_left)
        self.assertTrue(len(slices) - len(abandoned_slices) == 1)


    def test_dont_retain_full_slice_if_diff_slice_present_in_chain(self):
        limit = 1
        slices = [{'id': 76, 'size': 1000, 'kind': SLICE_KIND_FULL}]
        slices += [{'id': 77, 'size': 1000, 'kind': SLICE_KIND_INCREMENTAL}]
        slices += [{'id': 78, 'size': 1000, 'kind': SLICE_KIND_DIFFERENTIAL}]
        full_slice_id_should_left = 1112
        slices += [{'id': full_slice_id_should_left, 'size': 1000, 'kind': SLICE_KIND_FULL}]

        slices += [{'id': i, 'size': i*100, 'kind': SLICE_KIND_INCREMENTAL} for i in range(1, 3)]
        slices += [{'id': i, 'size': i*100, 'kind': SLICE_KIND_DIFFERENTIAL} for i in range(3, 5)]
        slices += [{'id': i, 'size': i*100, 'kind': SLICE_KIND_INCREMENTAL} for i in range(5, 7)]

        inc_slice_id_should_left = 1113
        slices += [{'id': inc_slice_id_should_left, 'size': 1000, 'kind': SLICE_KIND_DIFFERENTIAL}]

        abandoned_slices = retention.calculate_slices_abandoned_by_slice_count(slices, limit)
        #print('abandoned slices: ', abandoned_slices)
        slices_should_left = [full_slice_id_should_left, inc_slice_id_should_left]
        for slice in abandoned_slices:
            self.assertTrue(slice['id'] not in slices_should_left)
        self.assertTrue(len(slices) - len(abandoned_slices) == len(slices_should_left))


if __name__ == '__main__':
    unittest.main()
