# Run as 'python.exe -m acrobind.staging.test_retention_by_age' from enterprise/pybind folder

import acrobind.staging.retention as retention
from acrobind.staging import *

import datetime
import unittest

# Ordering of generated slices is from older to newer
class TestRetentions(unittest.TestCase):

    def test_retention_for_relative_date(self):

        print('Retention by 1 month')
        for i in range (1,13):
            time = datetime.datetime(2016, i, 25)
            retention_time = retention.relative_date(time, months=1)
            print(i, retention_time)
            if i >= 12:
                self.assertTrue(retention_time.year - time.year == 1)
                self.assertTrue(retention_time.month - time.month == -11)
            else:
                self.assertTrue(retention_time.year - time.year == 0)
                self.assertTrue(retention_time.month - time.month == 1)


        print('\nRetention by 12 months')
        for i in range (1,13):
            time = datetime.datetime(2016, i, 25)
            retention_time = retention.relative_date(time, months=12)
            print(i, retention_time)
            self.assertTrue(retention_time.year - time.year == 1)
            self.assertTrue(retention_time.month - time.month == 0)


        print('\nRetention by 23 months')
        for i in range (1,13):
            time = datetime.datetime(2016, i, 25)
            retention_time = retention.relative_date(time, months=23)
            print(i, retention_time)
            if i == 1:
                self.assertTrue(retention_time.year - time.year == 1)
                self.assertTrue(retention_time.month - time.month == 11)
            else:
                self.assertTrue(retention_time.year - time.year == 2)
                self.assertTrue(retention_time.month - time.month == -1)


        print('\nRetention by 25 months')
        for i in range (1,13):
            time = datetime.datetime(2016, i, 25)
            retention_time = retention.relative_date(time, months=25)
            print(i, retention_time)
            if i < 12:
                self.assertTrue(retention_time.year - time.year == 2)
                self.assertTrue(retention_time.month - time.month == 1)
            else:
                self.assertTrue(retention_time.year - time.year == 3)
                self.assertTrue(retention_time.month - time.month == -11)


        print('\nRetention by 97 months')
        for i in range (1,13):
            time = datetime.datetime(2016, i, 25)
            retention_time = retention.relative_date(time, months=97)
            print(i, retention_time)
            if i < 12:
                self.assertTrue(retention_time.year - time.year == 8)
                self.assertTrue(retention_time.month - time.month == 1)
            else:
                self.assertTrue(retention_time.year - time.year == 9)
                self.assertTrue(retention_time.month - time.month == -11)

if __name__ == '__main__':
    unittest.main()
