import acrort


def registry_read_string(key_name, value_name, *, hive=None, default=None):
    root = acrort.registry.open_system_hive(hive=hive)
    if key_name not in root.subkeys:
        return default
    key = root.subkeys.open(key_name=key_name)
    if value_name not in key.values:
        return default
    value = key.values.open(value_name=value_name)
    return value.get(acrort.registry.TYPE_SZ)


def registry_read_int(key_name, value_name, *, hive=None, default=None):
    root = acrort.registry.open_system_hive(hive=hive)
    if key_name not in root.subkeys:
        return default
    key = root.subkeys.open(key_name=key_name)
    if value_name not in key.values:
        return default
    value = key.values.open(value_name=value_name)
    return value.get(acrort.registry.TYPE_DWORD, acrort.registry.TYPE_QWORD)
