import acrort
from . constants import DEFAULT_PLAN_NAME_FOR_PROTECT_NOW, BACKUP_SCHEME_NOW
from . request_tokens import *


class Request:
    def __init__(self, *, plan_name=None, plan_id=None, backup_type, inclusions, stages, protect_now=False):
        if plan_id is None:
            plan_id = acrort.common.create_guid()
        elif not isinstance(plan_id, acrort.common.Guid):
            plan_id = acrort.common.Guid(plan_id)

        if plan_name is None and protect_now:
            plan_name = DEFAULT_PLAN_NAME_FOR_PROTECT_NOW

        self._plan_id = plan_id
        self._plan_name = str(plan_name)
        self._backup_type = backup_type
        self._inclusions = []
        self._stages = []
        self._options = {}
        self._protect_now = protect_now

        for inc in inclusions:
            if not isinstance(inc, acrort.plain.Unit):
                inc = acrort.plain.Unit(inc)
            self._inclusions.append(inc)

        for stage in stages:
            if not isinstance(stage, acrort.plain.Unit):
                stage = acrort.plain.Unit(stage)
            self._stages.append(stage)

        self.scheme = None

    def set_options(self, options):
        self._options = options

    def to_unit(self):
        plan = {
            ARG_PLAN_ID: self._plan_id,
            ARG_PLAN_NAME: self._plan_name,
            ARG_BACKUP_TYPE: self._backup_type,
            ARG_TARGET: {ARG_INCLUSIONS: self._inclusions},
            ARG_ROUTE: {ARG_STAGES: self._stages},
            ARG_OPTIONS: self._options
        }
        if self.scheme:
            plan[ARG_SCHEME] = self.scheme
        elif self._protect_now:
            plan[ARG_SCHEME] = {}
            plan[ARG_SCHEME][ARG_TYPE] = BACKUP_SCHEME_NOW
        return acrort.plain.Unit(plan)
