# @copyright (c) 2002-2013 Acronis International GmbH. All rights reserved.


class Singleton(type):
    def __call__(cls, *args, **kwargs):
        if cls.instance is None:
            cls.instance = super(Singleton, cls).__call__(*args, **kwargs)
        return cls.instance

    def __init__(cls, name, bases, methods):
        super(Singleton, cls).__init__(name, bases, methods)
        cls.instance = None
